#ifndef _PDH_H
#define _PDH_H
#if __GNUC__ >= 3
#pragma GCC system_header
#endif

#include <windows.h>
#include <winperf.h>

#ifdef __cplusplus
//extern "C" {
#endif

typedef LONG PDH_STATUS;
#define PDH_FUNCTION PDH_STATUS __stdcall

#define PDH_CVERSION_WIN40 ((DWORD)(0x0400))
#define PDH_VERSION ((DWORD)((PDH_CVERSION_WIN40) + 0x0003))

#define PDH_FMT_RAW     ((DWORD)0x00000010)
#define PDH_FMT_ANSI    ((DWORD)0x00000020)
#define PDH_FMT_UNICODE ((DWORD)0x00000040)
#define PDH_FMT_LONG    ((DWORD)0x00000100)
#define PDH_FMT_DOUBLE  ((DWORD)0x00000200)
#define PDH_FMT_LARGE   ((DWORD)0x00000400)
#define PDH_FMT_NOSCALE ((DWORD)0x00001000)
#define PDH_FMT_1000    ((DWORD)0x00002000)
#define PDH_FMT_NODATA  ((DWORD)0x00004000)

#define PERF_DETAIL_COSTLY   ((DWORD)0x00010000)
#define PERF_DETAIL_STANDARD ((DWORD)0x0000FFFF)

typedef HANDLE HCOUNTER;
typedef HANDLE HQUERY;
typedef HANDLE HLOG;

typedef struct _PDH_FMT_COUNTERVALUE {
	DWORD CStatus;
	union {
		long longValue;
		double doubleValue;
		long long largeValue;
		LPSTR AnsiStringValue;
		LPWSTR WideStringValue;
	};
} PDH_FMT_COUNTERVALUE, *PPDH_FMT_COUNTERVALUE;

PDH_FUNCTION PdhAddCounterA(HQUERY hQuery,LPCSTR szFullCounterPath,DWORD dwUserData,HCOUNTER *phCounter);
PDH_FUNCTION PdhAddCounterW(HQUERY hQuery,LPCWSTR szFullCounterPath,DWORD dwUserData,HCOUNTER *phCounter);
PDH_FUNCTION PdhCloseQuery(HQUERY hQuery);
PDH_FUNCTION PdhCollectQueryData(HQUERY hQuery);
PDH_FUNCTION PdhEnumObjectItemsA(LPCSTR szDataSource,LPCSTR szMachineName,LPCSTR szObjectName,LPSTR mszCounterList,LPDWORD pcchCounterListLength,LPSTR mszInstanceList,LPDWORD pcchInstanceListLength,DWORD dwDetailLevel,DWORD dwFlags);
PDH_FUNCTION PdhEnumObjectItemsW(LPCWSTR szDataSource,LPCWSTR szMachineName,LPCWSTR szObjectName,LPWSTR mszCounterList,LPDWORD pcchCounterListLength,LPWSTR mszInstanceList,LPDWORD pcchInstanceListLength,DWORD dwDetailLevel,DWORD dwFlags);
PDH_FUNCTION PdhGetFormattedCounterValue(HCOUNTER hCounter,DWORD dwFormat,LPDWORD lpdwType,PPDH_FMT_COUNTERVALUE pValue);
PDH_FUNCTION PdhOpenQueryA(LPCSTR szDataSource,DWORD dwUserData,HQUERY *phQuery);
PDH_FUNCTION PdhOpenQueryW(LPCWSTR szDataSource,DWORD dwUserData,HQUERY *phQuery);
PDH_FUNCTION PdhRemoveCounter(HCOUNTER hCounter);

#ifdef UNICODE
#define PdhAddCounter PdhAddCounterW
#define PdhEnumObjectItems PdhEnumObjectItemsW
#define PdhOpenQuery PdhOpenQueryW
#else /* UNICODE */
#define PdhAddCounter PdhAddCounterA
#define PdhEnumObjectItems PdhEnumObjectItemsA
#define PdhOpenQuery PdhOpenQueryA
#endif /* UNICODE */

#ifdef __cplusplus
}
#endif

#endif /* _PDH_H */
